#!/usr/bin/env python
# Ear Candy - Pulseaduio sound managment tool
# Copyright (C) 2008 Jason Taylor
# 
# This program is free software: you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation, either version 2 of the License, or
# (at your option) any later version.
# 
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
# 
# You should have received a copy of the GNU General Public License
# along with this program.  If not, see <http://www.gnu.org/licenses/>.

# based on original code by by RYX (aka Rico Pfaus)
# http://thegraveyard.org/files/kapager-0.0.3.py

import wnck
import gobject
import os
import gtk
from DesktopFiles import DesktopFiles

class Application():
    def __init__(self, pid, command, name, desktop_files, icon):
        self.command = os.path.basename(command.lower().strip())
        self.name = name.lower().strip()
        self.category = ""
        self.icon = icon
        self.icon_name = ""
        self.description = name

        # current application window info
        self.pid = pid
        self.window_name = ""
        self.x = 0
        self.y = 0
        self.fullscreen = False
        
        self.__match_desktop(desktop_files)
        return

    def __match_desktop(self,  desktop_files):

        #print "checking desktop files for match....", self.name
        # Try looking up the application list
        for a in desktop_files:
            ex = a.get_exec_array()[0].lower()

            # Check for pulse audio settings first...
            if a.get("X-PulseAudio-Properties"):
                self.category = a.get("X-PulseAudio-Properties")
                break

            if a.get("X-GNOME-Bugzilla-Product") == self.name or ex == self.name or ex == self.command or a.get("Name").lower() == self.name or a.get("Name").lower() == self.command or ex + ".real" == self.command :
                self.icon_name = a.get("Icon")
                self.description = a.get("Name")
                self.category = self.__desktop_categories_to_category( a.get("Categories") )
                #print "category : " + (self.category or "<unknown>")
                break

        if self.command == "skype.real":
            self.category = "phone"
            #print "category : " + self.category
            

    def __desktop_categories_to_category(self, categories):
        if categories:
            for category in categories:
                if "Telephony" in categories or "InstantMessaging" in categories:
                    return "phone"
                if "Music" in categories:
                    return "music"
                if "Video" in categories:
                    return "video"
                if "AudioVideo" in categories:
                    return "music"             
    
        return ""

class WindowWatcher():
    
    def __init__(self, callback = None, existing=False):
        self.screen = wnck.screen_get_default()
        self.screen.connect("active_window_changed", self.active_window_changed)
        self.screen.connect("window_opened", self.window_opened)
        self.callback = callback
        self.current_window = None
        self.applications = {}
        self.desktop_files = DesktopFiles().read_all()   

        for win in self.screen.get_windows():
            self.update("exists", win)

    def send_window_key_press_from_pid(self, pid, key):
        for win in self.screen.get_windows():
            app = win.get_application()
            app_name = app.get_name()
            if pid == win.get_pid():       
                
                break;


    def get_command(self, pid):
        command = str(pid)
        try:
            # Try and get command from PID
            f = open("/proc/%s/cmdline" % pid, "r")
            command = f.readline()[:-1]
            f.close()
        except:
            pass
        return command

    def window_opened(self, screen, win):
        if win and win.get_window_type() != wnck.WINDOW_DOCK: # ignore docks
            #print            
            #print "window opened"
            app = win.get_application ()
            app_name = app.get_name()
            pid = win.get_pid()
            command = self.get_command(pid)
            category = ""

            if not self.applications.has_key(command):
                a = Application(pid, command, app_name, self.desktop_files, win.get_icon ())
                self.applications[command] = a
            
            self.update("open", win)
            win.connect("geometry-changed", self.geometry_changed)

    def active_window_changed(self, screen, old_window):
        win = screen.get_active_window ()
        self.update("active", win)        

    def update(self, state, win):
        if win and win.get_window_type() != wnck.WINDOW_DOCK: # ignore docks
                
            #try:
                app = win.get_application ()
                app_name = app.get_name()
                pid = win.get_pid()

                command = self.get_command(pid)

                application = None
                application = self.applications[command]
                application.pid = pid

                geom = win.get_geometry()
                x = float(geom[1])
                y = float(geom[0])
                w = float(geom[2])
                h = float(geom[3])

                if win.get_name():
                    application.window_name =  win.get_name()

                application.x = x+h/2
                application.y = y+w/2
                application.fullscreen = win.is_fullscreen () or win.is_maximized ()
                application.icon = win.get_icon ()

                
                if self.callback:
                    gobject.idle_add(self.callback, application, state)
            #except:
            #    print "error reading window", win

    def geometry_changed(self, win):
        self.update("geo", win)


if __name__ == '__main__':
    ww = WindowWatcher()

